<?php 
if( !defined("WHMCS") ) 
{
    exit( "This file cannot be accessed directly" );
}

global $reseller_token;
$reseller_token = "YOUR_TOKEN";

$licensing = DI::make("license");
function tremhost_MetaData()
{
    return array( "DisplayName" => "Tremhost License", "APIVersion" => "1.1", "RequiresServer" => false );
}
function tremhost_TestConnection($params){
 if (empty($params['serveraccesshash'])) {
        return "Wrong ServerHash";
    }
}

function tremhost_ConfigOptions()
{
    $id = App::getFromRequest("id");
    $addonsCollection = WHMCS\Database\Capsule::table("tbladdons")->orderBy("weight", "asc")->orderBy("name", "asc")->get();
     $query = "CREATE TABLE `mod_licensing` (`id` INT( 10 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,`serviceid` INT( 10 ) NOT NULL ,`addon_id` INT(10) NOT NULL DEFAULT  0,`licensekey` TEXT NOT NULL ,`validdomain` TEXT NOT NULL ,`validip` TEXT NOT NULL ,`validdirectory` TEXT NOT NULL ,`reissues` INT( 1 ) NOT NULL ,`status` ENUM( 'Active', 'Reissued', 'Suspended', 'Expired' ) NOT NULL ,`lastaccess` datetime NOT NULL default '0000-00-00 00:00:00')";
    full_query($query);
    $query = "CREATE TABLE `mod_licensinglog` (`id` INT( 10 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,`licenseid` INT( 10 ) NOT NULL ,`domain` TEXT NOT NULL ,`ip` TEXT NOT NULL ,`path` TEXT NOT NULL ,`message` TEXT NOT NULL ,`datetime` datetime NOT NULL default '0000-00-00 00:00:00')";
    full_query($query);
    $query = "CREATE TABLE `mod_licensingbans` (`id` INT( 10 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,`type` VARCHAR(1) NOT NULL ,`value` TEXT NOT NULL ,`notes` TEXT NOT NULL )";
    full_query($query);
    $supportUpdateAddons = array(  );
    $supportUpdateAddons[00] = "None";
    $supportUpdateAddons[10] = "cPanel";
    $supportUpdateAddons[11] = "cPanelDedicated";
    $supportUpdateAddons[12] = "CloudLinux";
    $supportUpdateAddons[13] = "LiteSpeed";
    $supportUpdateAddons[14] = "LiteSpeedAdc";
    $supportUpdateAddons[15] = "Cxs";
    $supportUpdateAddons[16] = "WHMreseller";
    $supportUpdateAddons[17] = "JetBackup";
    $supportUpdateAddons[18] = "imunify360";
    $supportUpdateAddons[19] = "PleskLinuxVPS";
    $supportUpdateAddons[20] = "PleskLinuxDedicated";
    $supportUpdateAddons[21] = "directadmin";
    $supportUpdateAddons[22] = "dareseller";
    $supportUpdateAddons[23] = "whmsonic";
    $supportUpdateAddons[24] = "osm";
    $supportUpdateAddons[25] = "softaculous";
    $supportUpdateAddons[26] = "virtualizor";
    $supportUpdateAddons[27] = "whmcs";
    $supportUpdateAddons[28] = "sitepad";
    $supportUpdateAddons[29] = "SYSCare";
    $supportUpdateAddons[30] = "CPGuard";
    foreach( $addonsCollection as $addon ) 
    {
        $addonId = $addon->id;
        $addonName = str_replace(",", "&comma;", $addon->name);
        $addonPackages = explode(",", $addon->packages);
        if( in_array($id, $addonPackages) ) 
        {
            $supportUpdateAddons[$addonId] = $addonName;
        }
    }
    $configarray = array( "Products" => array( "Type" => "dropdown", "Options" => $supportUpdateAddons ) );
    return $configarray;
}
function tremhost_genkey($length, $prefix)
{
    if( !$length ) 
    {
        $length = 10;
    }
    $seeds = "abcdef0123456789";
    $key = NULL;
    $seeds_count = strlen($seeds) - 1;
    for( $i = 0; $i < $length; $i++ ) 
    {
        $key .= $seeds[rand(0, $seeds_count)];
    }
    $licensekey = $prefix . $key;
    $result = select_query("mod_licensing", "COUNT(*)", array( "licensekey" => $licensekey ));
    $data = mysql_fetch_array($result);
    if( $data[0] ) 
    {
        $licensekey = tremhost_genkey($length, $prefix);
    }
    return $licensekey;
}
function tremhost_CreateAccount(array $params) 
{
 if (!array_key_exists('IP', $params['customfields'])) {
 return "Ip Null!";
 }
  if (empty($params['customfields']['IP'])) {
        return "Ip Empty!";
    }
    
    $result = select_query( "mod_licensing", "COUNT(*)", array( "serviceid" => $params['serviceid'] ) );
    $data = mysql_fetch_array( $result );
    if ($data[0]) {
        return "A license has already been generated for this item";
    }
    $length = "5";
    $prefix = "RC-";
    $prod= array('10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30');
    $rep = array('Cpanel','CpanelDedicated','CloudLinux','LiteSpeed','LiteSpeedAdc','Cxs','WHMreseller','JetBackup','imunify360','PleskLinuxVPS','PleskLinuxDedicated','directadmin','dareseller','whmsonic','osm','softaculous','virtualizor','whmcs','sitepad','SYSCare','CPGuard');
    $productname=str_replace($prod,$rep,$params['configoption1']);
    $ma = array('Monthly','Quarterly','Semi-Annually','Annually','Biennially');
    $ra = array('1','3','6','12','24','36');
    $cycle = str_replace($ma,$ra,$params['model']['billingcycle']);
    if (!is_numeric($cycle)) $cycle = 1;
    global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'license','Product'=>$productname,'Ip'=>$params['customfields']['IP'],'billingcycle'=>$cycle]));
    $res = curl_exec($ch);
    if(json_decode($res)->ok=="True"){
    update_query("tblhosting", array("domainstatus" => "Active"), array("id" => $params["serviceid"]));
    $licensekey = tremhost_genkey( $length, $prefix );
    insert_query( "mod_licensing", array( "serviceid" => $params['serviceid'], "licensekey" => $licensekey, "validdomain" => "", "validip" => $params['customfields']['IP'], "validdirectory" => "", "reissues" => "0", "status" => "Active" ) );
    updateService( array( "domain" => $params['customfields']['IP'], "username" => "", "password" => $licensekey ) );
    $addonid = explode( "|", $params['configoption7'] );
    $addonid = $addonid[0];
    if ($addonid) {
        $result = select_query( "tblhosting", "orderid,paymentmethod", array( "id" => $params['serviceid'] ) );
        $data = mysql_fetch_array( $result );
        $orderid = $data['orderid'];
        $paymentmethod = $data['paymentmethod'];
        $result = select_query( "tbladdons", "", array( "id" => $addonid ) );
        $data = mysql_fetch_array( $result );
        $addonname = $data['name'];
        $result = select_query( "tblpricing", "", array( "relid" => $addonid, "type" => "addon", "currency" => $params['clientsdetails']['currency'] ) );
        $data2 = mysql_fetch_array( $result );
        $addonsetupfee = $data2['msetupfee'];
        $addonrecurring = $data2['monthly'];
        $addonbillingcycle = $data['billingcycle'];
        $addontax = $data['tax'];
        if ($addonbillingcycle == "Monthly") {
            $nextduedate = date( "Y-m-d", mktime( 0, 0, 0, date( "m" ) + 1, date( "d" ), date( "Y" ) ) );
        }
        else {
            if ($addonbillingcycle == "Quarterly") {
                $nextduedate = date( "Y-m-d", mktime( 0, 0, 0, date( "m" ) + 3, date( "d" ), date( "Y" ) ) );
            }
            else {
                if ($addonbillingcycle == "Semi-Annually") {
                    $nextduedate = date( "Y-m-d", mktime( 0, 0, 0, date( "m" ) + 6, date( "d" ), date( "Y" ) ) );
                }
                else {
                    if ($addonbillingcycle == "Annually") {
                        $nextduedate = date( "Y-m-d", mktime( 0, 0, 0, date( "m" ) + 12, date( "d" ), date( "Y" ) ) );
                    }
                    else {
                        if ($addonbillingcycle == "Biennially") {
                            $nextduedate = date( "Y-m-d", mktime( 0, 0, 0, date( "m" ) + 24, date( "d" ), date( "Y" ) ) );
                        }
                        else {
                            $nextduedate = "0000-00-00";
                        }
                    }
                }
            }
        }
        insert_query( "tblhostingaddons", array( "orderid" => $orderid, "hostingid" => $params['serviceid'], "addonid" => $addonid, "setupfee" => $addonsetupfee, "recurring" => $addonrecurring, "billingcycle" => $addonbillingcycle, "tax" => $addontax, "status" => "Active", "regdate" => "now()", "nextduedate" => $nextduedate, "nextinvoicedate" => $nextduedate, "paymentmethod" => $paymentmethod ) );
    }
    return "success";
    }else{

    return json_decode($res)->message;
    }

}
function tremhost_SuspendAccount($params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $existingLicense = tremhost_does_license_exist($params);
    if( !$existingLicense ) 
    {
        return "No license exists for this item";
    }
    $prod= array('10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30');
    $rep = array('Cpanel','CpanelDedicated','CloudLinux','LiteSpeed','LiteSpeedAdc','Cxs','WHMreseller','JetBackup','imunify360','PleskLinuxVPS','PleskLinuxDedicated','directadmin','dareseller','whmsonic','osm','softaculous','virtualizor','whmcs','sitepad','SYSCare','CPGuard');
    $productname=str_replace($prod,$rep,$params['configoption1']);
    global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'Ban','Product'=>$productname,'Ip'=>$params['customfields']['IP']]));
    $res = curl_exec($ch);
    if(json_decode($res)->ok=="True"){
    WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->update(array( "status" => "Suspended" ));
    return "success";
    }else{
    return json_decode($res)->message;
    }
}
function tremhost_UnsuspendAccount($params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $existingLicense = tremhost_does_license_exist($params);
    if( !$existingLicense ) 
    {
        return "No license exists for this item";
    }
    $prod= array('10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30');
    $rep = array('Cpanel','CpanelDedicated','CloudLinux','LiteSpeed','LiteSpeedAdc','Cxs','WHMreseller','JetBackup','imunify360','PleskLinuxVPS','PleskLinuxDedicated','directadmin','dareseller','whmsonic','osm','softaculous','virtualizor','whmcs','sitepad','SYSCare','CPGuard');
    $productname=str_replace($prod,$rep,$params['configoption1']);
    global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'UnBan','Product'=>$productname,'Ip'=>$params['customfields']['IP']]));
    $res = curl_exec($ch);
    if(json_decode($res)->ok=="True"){
    WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->update(array( "status" => "Active" ));
     return "success";
    }else{
    return json_decode($res)->message;
    }
}
function tremhost_TerminateAccount($params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $existingLicense = tremhost_does_license_exist($params);
    if( !$existingLicense ) 
    {
        return "No license exists for this item";
    }
    $prod= array('10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30');
    $rep = array('Cpanel','CpanelDedicated','CloudLinux','LiteSpeed','LiteSpeedAdc','Cxs','WHMreseller','JetBackup','imunify360','PleskLinuxVPS','PleskLinuxDedicated','directadmin','dareseller','whmsonic','osm','softaculous','virtualizor','whmcs','sitepad','SYSCare','CPGuard');
    $productname=str_replace($prod,$rep,$params['configoption1']);
    global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'Ban','Product'=>$productname,'Ip'=>$params['customfields']['IP']]));
    $res = curl_exec($ch);
    if(json_decode($res)->ok=="True"){
    WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->update(array( "status" => "Expired" ));
    return "success";
    }else{
    return json_decode($res)->message;
    }
}
function tremhost_AdminCustomButtonArray()
{
    $buttonarray = array( "Renew license" => "ReNew" );
    return $buttonarray;
}
function tremhost_ClientAreaCustomButtonArray()
{
    $buttonarray = array( "ChangeIp"=>"ChangeIp" );
    return $buttonarray;
}

function tremhost_revoke($params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $existingLicense = tremhost_does_license_exist($params);
    if( !$existingLicense ) 
    {
        return "No license exists for this item";
    }
    WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->delete();
    updateService(array( "domain" => "" ));
    return "success";
}
function tremhost_ReNew($params)
{
   $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $existingLicense = tremhost_does_license_exist($params);
    if( !$existingLicense ) 
    {
        return "No license exists for this item";
    }
    $prod= array('10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30');
    $rep = array('Cpanel','CpanelDedicated','CloudLinux','LiteSpeed','LiteSpeedAdc','Cxs','WHMreseller','JetBackup','imunify360','PleskLinuxVPS','PleskLinuxDedicated','directadmin','dareseller','whmsonic','osm','softaculous','virtualizor','whmcs','sitepad','SYSCare','CPGuard');
    $productname=str_replace($prod,$rep,$params['configoption1']);
    $ma = array('Monthly','Quarterly','Semi-Annually','Annually','Biennially');
    $ra = array('1','3','6','12','24','36');
    $cycle = str_replace($ma,$ra,$params['model']['billingcycle']);
    if (!is_numeric($cycle)) $cycle = 1;
    global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'ReNew','Product'=>$productname,'Ip'=>$params['customfields']['IP'],'billingcycle'=>$cycle]));
    $res = curl_exec($ch);
    if(json_decode($res)->ok=="True"){
    return "success";
    }else{
    return json_decode($res)->message;
    }
}
function tremhost_valid_input_clean($vals)
{
    $vals = explode(",", $vals);
    foreach( $vals as $k => $v ) 
    {
        $vals[$k] = trim($v, " \t\n\r");
    }
    return implode(",", $vals);
}
function tremhost_AdminServicesTabFields($params)
{
    global $aInt;
    $license = tremhost_get_license($params);
    if( $license ) 
    {
        $licenseId = $license->id;
        $validdomain = $license->validdomain;
        $validip = $license->validip;
        $validdirectory = $license->validdirectory;
        $reissues = $license->reissues;
        $status = $license->status;
        $lastAccess = $license->lastaccess;
        if( $lastAccess == "0000-00-00 00:00:00" ) 
        {
            $lastAccess = "Never";
        }
        else
        {
            $lastAccess = fromMySQLDate($lastAccess, "time");
        }
        $statusoptions = "<option";
        if( $status == "Active" ) 
        {
            $statusoptions .= " selected";
        }
        $statusoptions .= ">Active</option><option";
        if( $status == "Suspended" ) 
        {
            $statusoptions .= " selected";
        }
        $statusoptions .= ">Suspended</option><option";
        if( $status == "Expired" ) 
        {
            $statusoptions .= " selected";
        }
        $statusoptions .= ">Expired</option>";
        $licenseLogs = WHMCS\Database\Capsule::table("mod_licensinglog")->where("licenseid", "=", $licenseId)->orderBy("id", "DESC")->limit(10)->offset(0)->get();
        $tableData = array(  );
        foreach( $licenseLogs as $licenseLog ) 
        {
            $tableData[] = array( fromMySQLDate($licenseLog->datetime, true), $licenseLog->domain, $licenseLog->ip, $licenseLog->path, $licenseLog->message );
        }
        $aInt->sortableTableInit("nopagination");
        $recentAccessLog = $aInt->sortableTable(array( "Date", "Domain", "IP", "Path", "Result" ), $tableData);
        $fieldsArray = array(  "License Status" => "<select name=\"modulefields[3]\" id=\"licensestatus\" class=\"form-control select-inline\">" . $statusoptions . "</select>");
        return $fieldsArray;
    }
    else
    {
        return array(  );
    }
}
function tremhost_AdminServicesTabFieldsSave($params)
{
    update_query("mod_licensing", array( "validdomain" => tremhost_valid_input_clean($_POST["modulefields"][0]), "validip" => tremhost_valid_input_clean($_POST["modulefields"][1]), "validdirectory" => tremhost_valid_input_clean($_POST["modulefields"][2]), "status" => $_POST["modulefields"][3] ), array( "serviceid" => $params["serviceid"] ));
}

function tremhost_ClientArea($params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $model = $params["model"];
    $licenseData = WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->first();
    $productName = ($model instanceof WHMCS\Service\Addon ? $model->productAddon->name : $model->product->name);
    $licenseKey = $licenseData->licensekey;
    $validDomain = $licenseData->validdomain;
    $validIp = $params['customfields']['IP'];
    
    if($licenseData->validdirectory != ""){
    $validDirectory = $licenseData->validdirectory;
    }else{
        global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'ShowHelp'] + ['serviceid'=>$params['configoption1']]));
    $res = curl_exec($ch);
    $validDirectory= json_decode($res)->message;
    }
    $status = $licenseData->status;
    $licenseCk = tremhost_get_license($params);
    if( $model instanceof WHMCS\Service\Addon ) 
    {
        $allowReissues = (bool) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption3")->first()->value;
        $allowDomainConflicts = (bool) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption4")->first()->value;
        $allowIpConflicts = (bool) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption5")->first()->value;
        $allowDirectoryConflicts = (bool) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption6")->first()->value;
    }
    else
    {
        $allowReissues = (bool) $model->product->moduleConfigOption3;
        $allowDomainConflicts = (bool) $model->product->moduleConfigOption4;
        $allowIpConflicts = (bool) $model->product->moduleConfigOption5;
        $allowDirectoryConflicts = (bool) $model->product->moduleConfigOption6;
    }
    if($licenseCk->reissues > 2){
    $allowReissues = true;
    }else{
    $allowReissues = false;   
    }
    return array( "overrideDisplayTitle" => $productName, "overrideBreadcrumb" => array( array( "clientarea.php?action=products&module=tremhost", Lang::trans("licensingaddon.mylicenses") ), array( "clientarea.php?action=productdetails#", Lang::trans("licensingaddon.manageLicense") ) ), "tabOverviewReplacementTemplate" => "managelicense.tpl", "tabOverviewModuleOutputTemplate" => "licenseinfo.tpl", "templateVariables" => array( "licensekey" => $licenseKey, "validdomain" => $validDomain, "validip" => $validIp, "validdirectory" => $validDirectory, "status" => $status, "allowreissues" => $allowReissues, "allowDomainConflicts" => $allowDomainConflicts, "allowIpConflicts" => $allowIpConflicts, "allowDirectoryConflicts" => $allowDirectoryConflicts ) );
}
function tremhost_ChangeIp($params){
   $license = tremhost_get_license($params);
   
    if($license->reissues < 3){
    $prod= array('10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30');
    $rep = array('Cpanel','CpanelDedicated','CloudLinux','LiteSpeed','LiteSpeedAdc','Cxs','WHMreseller','JetBackup','imunify360','PleskLinuxVPS','PleskLinuxDedicated','directadmin','dareseller','whmsonic','osm','softaculous','virtualizor','whmcs','sitepad','SYSCare','CPGuard');
    $productname=str_replace($prod,$rep,$params['configoption1']);
    if(isset($_POST['IPc'])&&$_POST['IPc']!=""&&$params['customfields']['IP']!=$_POST['IPc']){
        global $reseller_token;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,"http://api.resellercenter.ir/rc/");
    curl_setopt($ch,CURLOPT_USERAGENT, 'ResellerCenter');
    curl_setopt($ch,CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query(['token'=>"$reseller_token"] + ['action'=>'ChangeIp','Product'=>$productname,'Ip'=>$params['customfields']['IP'],'Replace'=>$_POST['IPc']]));
    $res = curl_exec($ch);
    $ok= json_decode($res)->ok;
    if($ok=="True"){
    update_query('tblhosting', array('domain' => $_POST['IPc'],),
                array('id' => $params["serviceid"],));
    update_query('tblcustomfieldsvalues', array('value' => $_POST['IPc'],),
                array('value' => $params['customfields']['IP'], 'relid' => $params["serviceid"],));
    WHMCS\Database\Capsule::table("mod_licensing")->where("id", "=", $license->id)->increment("reissues", 1);
    return "success";
    }else{
    return json_decode($res)->message;
    }
    }else{
    return "Error!";
    }
    
    }else{
    return "this license has changed IP for too many times, contact support";
    }
}
function tremhost_does_license_exist(array $params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    return WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->count();
}
function tremhost_get_license(array $params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    return WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->first();
}